#version 150
#define MAX_STEPS 100
#define MAX_DIST 100.0
#define SURF_DIST 0.1
//By Z22
//Contains a bunch of code from ...
// "ShaderToy Tutorial - Ray Marching for Dummies!"
// by Martijn Steinrucken aka BigWings/CountFrolic - 2018
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//
// This shader is part of a tutorial on YouTube
// https://youtu.be/PGtv-dBi2wE
// https://www.shadertoy.com/view/XlGBW3

uniform sampler2D texture0;
uniform float u_Elapsed;



in vec4 gl_FragCoord ;
vec2 fragCoord = gl_FragCoord.xy;
in vec4 gl_TexCoord[];
vec4 vTexCoord = gl_TexCoord[0];
uniform vec2 textureSize0;
vec2 Offset = vec2(1.0) / textureSize0;
vec2 uv = ((fragCoord-0.5*textureSize0.xy)/textureSize0.y)*1.5;



///////////////////
vec4 col   = texture2D ( texture0, vTexCoord.xy  ) ;//girl
// vec3 col;



// Calgon stuff
uniform float image_num;
uniform float scenes;
uniform float scene_change;

//float scenes = 25.0;		// Number of background images in the scene
//float scene_change = 6.;	// Time between image changes

float cycle_time = scenes * scene_change;
float part_cycles = 0.;
float alpha_on = (image_num - 1) * scene_change;
float alpha_off = image_num * scene_change;


void main(void)
{
	
	part_cycles = u_Elapsed;
	for (int i = 0; i < 3000; i++) {
		if (part_cycles >= cycle_time){
			part_cycles -= cycle_time;
			if (part_cycles < cycle_time){
			  i = 3000;
			}
		}
	}
    //float red_factor = sin(u_Elapsed * 1.2) + 1.5;
	//float red_factor = sin(u_Elapsed * 1.2) + 1.0;
	float red_factor = sin(u_Elapsed * 1.0) + 1.0;
	
	
	float grey = (col.r + col.g + col.b)/3;
	col.r *= red_factor * 0.5;
	if (col.r < grey){
	  col.r = grey;
	}
//	if (col.r < 0.1){
//			  col.r = 1 - col.r; 
//			  col.g = 1 - col.g; 
//			  col.b = 1 - col.b; 
			
//	}
	
	
	
	
	float my_alpha = 0.0;
	col.a = 0.0;
	if (part_cycles >= alpha_on - 1){				// Image needs to be in place 1 second early ready for old image fading
		if (part_cycles < alpha_off){
			col.a = 1.0;
			if (part_cycles > alpha_on + scene_change - 1.){
				col.a = alpha_off - part_cycles;	// Fade the image for the last second
			}
			
			
			
		}
		
		
		
		
	}
	gl_FragColor = vec4( col);
}
